const float meshscale=0.05*3.0;



#define MAX_LIGHTS 8
#define MAX_BONES 78

#define NUMLIGHTS 4


uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];

varying vec4 vpos; 

    varying vec3 v;
    varying vec3 N;
    varying vec3 T;
    varying vec3 B;

in vec3 vertexPosition;
in vec3 vertexNormal;
in vec2 textureCoord;
in vec3 vertexTangent;
in float vertexTangentHandedness;
in vec4 vertexBones1;
in vec4 vertexWeights1;
in vec3 explosionNormal;
in vec3 explosionIndex;
in vec3 explosionRnd;
in vec4 vertexBones2;
in vec4 vertexWeights2;

uniform int explosiontype;
uniform float doexplosion;
uniform float expltimer;
uniform float explosionIndexCount;
uniform float div_;
uniform float exp_;

uniform mat4 depthBiasMVP[NUMLIGHTS];
varying vec4 ShadowCoord[NUMLIGHTS];

uniform vec4 Lights[NUMLIGHTS];
uniform vec4 LightsPos[NUMLIGHTS];

varying float ShadowAngle[NUMLIGHTS];
varying vec4 vN_;
varying vec4 vP_;



uniform int hasAnim[1];
uniform mat4 bonePos[MAX_BONES];
uniform mat4 boneRPos[MAX_BONES];
uniform mat4 boneRot[MAX_BONES];
uniform mat4 boneScl[MAX_BONES];

varying vec3 alightVec[MAX_LIGHTS];
varying vec3 aeyeVec[MAX_LIGHTS];
varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];





vec3 tmpVec;

varying vec4 flashcolor;

void main(void)
{
flashcolor=vec4(0,0,0,0);

vec4 vP;
vec4 vN;
vec4 vT;
vec4 vPa[8];
vec4 vNa[8];
vec4 vTa[8];
	
	
	
	vP=vec4(vertexPosition.xyz, 1.0);
	vN=vec4(vertexNormal.xyz, 1.0);
	vT=vec4(vertexTangent.xyz, 1.0);
    

vN_=vN;
vP_=vP;


	if (hasAnim[0]>0){
        if (vertexBones1.x>=0){

            vPa[0]=vP;
            vPa[0].x-=bonePos[int(vertexBones1.x)][0][3];
            vPa[0].y-=bonePos[int(vertexBones1.x)][1][3];
            vPa[0].z-=bonePos[int(vertexBones1.x)][2][3];
            vPa[0]=boneRot[int(vertexBones1.x)]*vPa[0];
            vPa[0].x+=bonePos[int(vertexBones1.x)][0][3];
            vPa[0].y+=bonePos[int(vertexBones1.x)][1][3];
            vPa[0].z+=bonePos[int(vertexBones1.x)][2][3];
            vPa[0].x+=boneRPos[int(vertexBones1.x)][0][3];vPa[0].y+=boneRPos[int(vertexBones1.x)][1][3];vPa[0].z+=boneRPos[int(vertexBones1.x)][2][3];

            vNa[0]=vN;
            vNa[0]=boneRot[int(vertexBones1.x)]*vNa[0];
            
            

            vTa[0]=vT;
            vTa[0]=boneRot[int(vertexBones1.x)]*vTa[0];
            
            


            
            
            
        }
        if (vertexBones1.y>=0){
            
            
            vPa[1]=vP;
            vPa[1].x-=bonePos[int(vertexBones1.y)][0][3];
            vPa[1].y-=bonePos[int(vertexBones1.y)][1][3];
            vPa[1].z-=bonePos[int(vertexBones1.y)][2][3];
            vPa[1]=boneRot[int(vertexBones1.y)]*vPa[1];
            vPa[1].x+=bonePos[int(vertexBones1.y)][0][3];
            vPa[1].y+=bonePos[int(vertexBones1.y)][1][3];
            vPa[1].z+=bonePos[int(vertexBones1.y)][2][3];
            vPa[1].x+=boneRPos[int(vertexBones1.y)][0][3]; vPa[1].y+=boneRPos[int(vertexBones1.y)][1][3]; vPa[1].z+=boneRPos[int(vertexBones1.y)][2][3];

            vNa[1]=vN;
            vNa[1]=boneRot[int(vertexBones1.y)]*vNa[1];
            
            

            vTa[1]=vT;
            vTa[1]=boneRot[int(vertexBones1.y)]*vTa[1];
            
            

        }
        if (vertexBones1.z>=0){
            
            
            vPa[2]=vP;
            vPa[2].x-=bonePos[int(vertexBones1.z)][0][3];
            vPa[2].y-=bonePos[int(vertexBones1.z)][1][3];
            vPa[2].z-=bonePos[int(vertexBones1.z)][2][3];
            vPa[2]=boneRot[int(vertexBones1.z)]*vPa[2];
            vPa[2].x+=bonePos[int(vertexBones1.z)][0][3];
            vPa[2].y+=bonePos[int(vertexBones1.z)][1][3];
            vPa[2].z+=bonePos[int(vertexBones1.z)][2][3];
            vPa[2].x+=boneRPos[int(vertexBones1.z)][0][3];vPa[2].y+=boneRPos[int(vertexBones1.z)][1][3];vPa[2].z+=boneRPos[int(vertexBones1.z)][2][3];

            vNa[2]=vN;
            vNa[2]=boneRot[int(vertexBones1.z)]*vNa[2];
            
            

            vTa[2]=vT;
            vTa[2]=boneRot[int(vertexBones1.z)]*vTa[2];
            
            
        }
        if (vertexBones1.w>=0){
            
            
            vPa[3]=vP;
            vPa[3].x-=bonePos[int(vertexBones1.w)][0][3];
            vPa[3].y-=bonePos[int(vertexBones1.w)][1][3];
            vPa[3].z-=bonePos[int(vertexBones1.w)][2][3];
            vPa[3]=boneRot[int(vertexBones1.w)]*vPa[3];
            vPa[3].x+=bonePos[int(vertexBones1.w)][0][3];
            vPa[3].y+=bonePos[int(vertexBones1.w)][1][3];
            vPa[3].z+=bonePos[int(vertexBones1.w)][2][3];
            vPa[3].x+=boneRPos[int(vertexBones1.w)][0][3];vPa[3].y+=boneRPos[int(vertexBones1.w)][1][3]; vPa[3].z+=boneRPos[int(vertexBones1.w)][2][3];

            vNa[3]=vN;
            vNa[3]=boneRot[int(vertexBones1.w)]*vNa[3];
            
            

            vTa[3]=vT;
            vTa[3]=boneRot[int(vertexBones1.w)]*vTa[3];
            
            
        }
        
        if (vertexBones2.x>=0){

            vPa[4]=vP;
            vPa[4].x-=bonePos[int(vertexBones2.x)][0][3];
            vPa[4].y-=bonePos[int(vertexBones2.x)][1][3];
            vPa[4].z-=bonePos[int(vertexBones2.x)][2][3];
            vPa[4]=boneRot[int(vertexBones2.x)]*vPa[4];
            vPa[4].x+=bonePos[int(vertexBones2.x)][0][3];
            vPa[4].y+=bonePos[int(vertexBones2.x)][1][3];
            vPa[4].z+=bonePos[int(vertexBones2.x)][2][3];
            vPa[4].x+=boneRPos[int(vertexBones2.x)][0][3];vPa[4].y+=boneRPos[int(vertexBones2.x)][1][3];vPa[4].z+=boneRPos[int(vertexBones2.x)][2][3];

            vNa[4]=vN;
            vNa[4]=boneRot[int(vertexBones2.x)]*vNa[0];
            
            

            vTa[4]=vT;
            vTa[4]=boneRot[int(vertexBones2.x)]*vTa[0];
            
            


            
            
            
        }
        if (vertexBones2.y>=0){
            
            
            vPa[5]=vP;
            vPa[5].x-=bonePos[int(vertexBones2.y)][0][3];
            vPa[5].y-=bonePos[int(vertexBones2.y)][1][3];
            vPa[5].z-=bonePos[int(vertexBones2.y)][2][3];
            vPa[5]=boneRot[int(vertexBones2.y)]*vPa[5];
            vPa[5].x+=bonePos[int(vertexBones2.y)][0][3];
            vPa[5].y+=bonePos[int(vertexBones2.y)][1][3];
            vPa[5].z+=bonePos[int(vertexBones2.y)][2][3];
            vPa[5].x+=boneRPos[int(vertexBones2.y)][0][3]; vPa[5].y+=boneRPos[int(vertexBones2.y)][1][3]; vPa[5].z+=boneRPos[int(vertexBones2.y)][2][3];

            vNa[5]=vN;
            vNa[5]=boneRot[int(vertexBones2.y)]*vNa[1];
            
            

            vTa[5]=vT;
            vTa[5]=boneRot[int(vertexBones2.y)]*vTa[1];
            
            

        }
        if (vertexBones2.z>=0){
            
            
            vPa[6]=vP;
            vPa[6].x-=bonePos[int(vertexBones2.z)][0][3];
            vPa[6].y-=bonePos[int(vertexBones2.z)][1][3];
            vPa[6].z-=bonePos[int(vertexBones2.z)][2][3];
            vPa[6]=boneRot[int(vertexBones2.z)]*vPa[6];
            vPa[6].x+=bonePos[int(vertexBones2.z)][0][3];
            vPa[6].y+=bonePos[int(vertexBones2.z)][1][3];
            vPa[6].z+=bonePos[int(vertexBones2.z)][2][3];
            vPa[6].x+=boneRPos[int(vertexBones2.z)][0][3];vPa[6].y+=boneRPos[int(vertexBones2.z)][1][3];vPa[6].z+=boneRPos[int(vertexBones2.z)][2][3];

            vNa[6]=vN;
            vNa[6]=boneRot[int(vertexBones2.z)]*vNa[2];
            
            

            vTa[6]=vT;
            vTa[6]=boneRot[int(vertexBones2.z)]*vTa[2];
            
            
        }
        if (vertexBones2.w>=0){
            
            
            vPa[7]=vP;
            vPa[7].x-=bonePos[int(vertexBones2.w)][0][3];
            vPa[7].y-=bonePos[int(vertexBones2.w)][1][3];
            vPa[7].z-=bonePos[int(vertexBones2.w)][2][3];
            vPa[7]=boneRot[int(vertexBones2.w)]*vPa[7];
            vPa[7].x+=bonePos[int(vertexBones2.w)][0][3];
            vPa[7].y+=bonePos[int(vertexBones2.w)][1][3];
            vPa[7].z+=bonePos[int(vertexBones2.w)][2][3];
            vPa[7].x+=boneRPos[int(vertexBones2.w)][0][3];vPa[7].y+=boneRPos[int(vertexBones2.w)][1][3]; vPa[7].z+=boneRPos[int(vertexBones2.w)][2][3];

            vNa[7]=vN;
            vNa[7]=boneRot[int(vertexBones2.w)]*vNa[3];
            
            

            vTa[7]=vT;
            vTa[7]=boneRot[int(vertexBones2.w)]*vTa[3];
            
            
        }

        vP=vPa[0]*vertexWeights1.x+vPa[1]*vertexWeights1.y+vPa[2]*vertexWeights1.z+vPa[3]*vertexWeights1.w;
        vP+=vPa[4]*vertexWeights2.x+vPa[5]*vertexWeights2.y+vPa[6]*vertexWeights2.z+vPa[7]*vertexWeights2.w;
        vP=vec4(vP.xyz, 1.0);
        vN=vNa[0]*vertexWeights1.x+vNa[1]*vertexWeights1.y+vNa[2]*vertexWeights1.z+vNa[3]*vertexWeights1.w;
        vN+=vNa[4]*vertexWeights2.x+vNa[5]*vertexWeights2.y+vNa[6]*vertexWeights2.z+vNa[7]*vertexWeights2.w;
        vN=vec4(vN.xyz, 1.0);
        vT=vTa[0]*vertexWeights1.x+vTa[1]*vertexWeights1.y+vTa[2]*vertexWeights1.z+vTa[3]*vertexWeights1.w;
        vT+=vTa[4]*vertexWeights2.x+vTa[5]*vertexWeights2.y+vTa[6]*vertexWeights2.z+vTa[7]*vertexWeights2.w;
        vT=vec4(vT.xyz, 1.0);
	}

    if (doexplosion>0.0){
    if (explosiontype==0)
    {
        
        float expltimer_=expltimer*5.0; 
        expltimer_-=4.0*explosionIndex.x/(explosionIndexCount+1.0);
        
        expltimer_*=4.0;

        expltimer_/=12.0; 

        if (expltimer_<0.0) expltimer_=0.0;
        if (expltimer_>1.0) expltimer_=1.0;
        
        expltimer_=1.0-sin(expltimer_*3.14+6.28/4.0);

        vec4 vExpl=vec4(0,0,0,0);

        vExpl.z+=expltimer_*20.0;

        vExpl+=vec4(normalize(explosionNormal)*5.0*expltimer_/1.5,0.0);
        
float rndexpltimer=expltimer; if (rndexpltimer>1.0) rndexpltimer=2.0-rndexpltimer;
rndexpltimer=clamp(rndexpltimer,0.0,1.0);
rndexpltimer=(vertexPosition.z+(rndexpltimer-0.5)*7.5)/15.0; 
rndexpltimer=clamp(rndexpltimer,0.0,1.0);
const float boost=2.5;
vExpl+=vec4((explosionRnd+vec3(-0.5,-0.5,-0.5))*0.66*rndexpltimer*0.66*boost,1.0);
        
        vP+=vExpl;
    } else {
        
        vec4 vExpl=vec4(0,0,0,0);
        
        
        float ycenter; ycenter=mod(expltimer*2.0*17.0,17.0);
        
        
        

        
        

        
        
        float strength=abs(vP.z*meshscale-ycenter+2.0)/17.0;
        
        strength=1.0-clamp(strength,0.0,1.0);
        
        strength=pow(strength,30.0);
       
        
        
        float strengthmax=1.0/50.0/2.6/0.225; 
strengthmax/=1.5;

        strength=strengthmax*strength*2.0; 
        


strength=0.0; 


        float expltimer_=expltimer*5.0; 
        expltimer_-=4.0*explosionIndex.x/(explosionIndexCount+1.0);
        expltimer_/=3.0; 
        
        
        
        
        
        
        vExpl+=vec4((explosionRnd+vec3(-0.5,-0.5,-0.5))*0.66*0.66*33.4,1.0);
        
        vP*=meshscale;
        vP+=vExpl*strength;

        float color=pow(strength*2.0*5.0*1.33,1.3);
        flashcolor=vec4(color,color,color,1.0);
    }
    }

    
    gl_Position = gl_ModelViewProjectionMatrix * vec4(vP.xyz, 1.0f); 

    


 




vpos=gl_ModelViewMatrix * vec4(vP.xyz, 1.0f);


for (int i=0;i<NUMLIGHTS;i++){
    ShadowCoord[i] = depthBiasMVP[i] * vec4(vP.xyz, 1.0f);
}

    texCoord = textureCoord;

	
	vec3 n = normalize(gl_NormalMatrix * vec3(vN.x,vN.y,vN.z));
	vec3 t = normalize(gl_NormalMatrix * vec3(vT.x,vT.y,vT.z));
	
	
	
	


	vec3 b = cross(n, t) * vertexTangentHandedness;
    
	
	

	
	vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(vP.xyz, 1.0));

    
    
    

    
for (int i=0;i<NUMLIGHTS;i++){
    

    
    ShadowAngle[i] = dot(normalize(vec3(Lights[i].xyz)),n);

    

    
    
    

}
    
    

for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	
    tmpVec = vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i]) - vVertex;

	alightVec[i].x = dot(tmpVec, t);
	alightVec[i].y = dot(tmpVec, b);
	alightVec[i].z = dot(tmpVec, n);

	tmpVec = -vVertex;



	}
   }

   
   
    v=vVertex;
    N=normalize(n);
    T=normalize(t);
    B=normalize(b);
}
